using System;
using System.Collections.Generic;
using System.Net.Http;

namespace APIClientSample
{
    class Sample
    {
        static void Main(string[] args)
        {
            string api_server = "http://api.demo.wareconn.com";
            string client_id = "1234567890abc";
            string client_secret = "qwertyuiopasdfghjklzcvbnm1234567";

            string token = "qwertyuiopasdfghjklzcvbnm1234567qwertyuiopasdfghjklzcvbnm1234567";

            Dictionary<string, string> postParams = new Dictionary<string, string>();

            //1.get token
            string requestUrl = api_server + "/v1/Oauth/token";
            postParams.Add("client_id", client_id);
            postParams.Add("client_secret", client_secret);
            postParams.Add("grant_type", "client_credentials");

            //2.refresh token
            //string requestUrl = api_server + "/v1/Oauth/token";
            //postParams.Add("refresh_token", "qwertyuiopasdfghjklzxcvbnm123456789");
            //postParams.Add("grant_type", "refresh_token");

            //3.normal state
            //string requestUrl = api_server + "/v1/u/Info/provider";
            //postParams.Add("token", token);

            WareconnAPIClient apiClient = new WareconnAPIClient(client_id, client_secret);
            object rs = apiClient.request(requestUrl, HttpMethod.Post, postParams);
            Console.WriteLine(rs);
            Console.ReadKey();
        }
    }
}
