﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Threading.Tasks;
using Newtonsoft.Json;

namespace APIClientSample
{
    class WareconnAPIClient
    {
        private string client_id;
        private string client_secret;
        private Task<string> data;

        public WareconnAPIClient(string client_id, string client_secret)
        {
            this.client_id = client_id;
            this.client_secret = client_secret;
        }
        /**
         * 送交參數
         * @param url 接口路徑
         * @param method 存取方法HttpMethod.Get|HttpMethod.Post|HttpMethod.Put|HttpMethod.Delete
         * @param postParams
         * 
         */
        public object request(string url, HttpMethod method, Dictionary<string, string> postParams)
        {
            string json = this.sendRequest(url, method, postParams).Result;
            object jsonObj = JsonConvert.DeserializeObject(json);
            return jsonObj;
        }
        
        private async Task<string> sendRequest(string url, HttpMethod method, Dictionary<string, string> postParams) {

            Uri path = new Uri(url);
            HttpClient client = new HttpClient();

            client.DefaultRequestHeaders.Accept.Clear();
            client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/json"));

            HttpRequestMessage request = new HttpRequestMessage(method, path);


            string postJson = JsonConvert.SerializeObject(postParams, Formatting.Indented);

            request.Content = new StringContent(postJson, Encoding.UTF8, "application/json");

            await client.SendAsync(request).ContinueWith(responseTask =>
            {
                this.data = responseTask.Result.Content.ReadAsStringAsync();

            });
            string jsonData = await data;

            return jsonData;
        }

    }
}
