package APIClientSample;

import java.util.*;
import java.io.*;
//import java.security.*;
import java.net.*;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.databind.*;



public class WareconnAPIClient {

    /**
     * 送交參數
     * @param url 接口路徑
     * @param method 存取方法GET|POST|PUT|DELETE
     * @param params
     */
    public String request(String url,String method,LinkedHashMap params) {
        String rsJson = this.send(url,method, params);
        return rsJson;
    }


    public String send(String targetURL, String method,LinkedHashMap params)
    {
        URL url;
        HttpURLConnection connection = null;
        ObjectMapper mapper = new ObjectMapper();
        mapper.getFactory().configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
        try {
            if(method == "GET"){
                String queryStr = this.httpBuildQuery(params);
                url = new URL(targetURL+"?"+queryStr);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod(method);
                connection.setRequestProperty("Content-Type",
                        "application/json");
                connection.setUseCaches(false);
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setAllowUserInteraction(false);
            }else{
                String jsonString = mapper.writeValueAsString(params);
                url = new URL(targetURL);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod(method);
                connection.setRequestProperty("Content-Type",
                        "application/json");
                connection.setRequestProperty("Content-Length", "" +
                        Integer.toString(jsonString.getBytes().length));
                connection.setUseCaches(false);
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setAllowUserInteraction(false);
                DataOutputStream wr = new DataOutputStream (
                        connection.getOutputStream ());
                wr.writeBytes (jsonString);
                wr.flush ();
                wr.close ();
            }

            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            String line;
            StringBuffer response = new StringBuffer();
            while((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            rd.close();
            return response.toString();
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        } finally {
            if(connection != null) {
                connection.disconnect();
            }
        }
    }
    
    private String httpBuildQuery(LinkedHashMap<String, String> data) {
        QueryStringBuilder builder = new QueryStringBuilder();
        Set set = data.entrySet();
        Iterator iterator = set.iterator();
        while(iterator.hasNext()) {
            Map.Entry me = (Map.Entry)iterator.next();
            builder.appendParam(me.getKey().toString(), me.getValue().toString());
        }
        return builder.toString();
    }

}
