import json,numpy
import http.client
from urllib.parse import urlparse

class WareconnAPIClient(object):

    #送交參數
    #param url 接口路徑
    #param method 存取方法GET|POST|PUT|DELETE
    #param params
    def request(self, url, method, params):
        json_params = json.dumps(params,cls=MyEncoder)
        parsed_uri = urlparse(url)
        hostname = parsed_uri.netloc
        headers = {"Content-type": "application/json; charset=UTF-8"}
        conn = http.client.HTTPConnection(hostname)
        conn.request(method, url, json_params, headers)
        response = conn.getresponse()

        if(response.reason == "OK"):
            tmp = response.read()
            json_data = tmp.decode()
            conn.close()
            return json.loads(json_data)
        else:
            conn.close()
            return False


class MyEncoder(json.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, numpy.integer):
            return int(obj)
        elif isinstance(obj, numpy.floating):
            return float(obj)
        elif isinstance(obj, numpy.ndarray):
            return obj.tolist()
        else:
            return super(MyEncoder, self).default(obj)



